package fr.asip.cps3.exemple.vues.composants;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;

/**
 * Le <code>GridBagHelper</code> facilite l'utilisation de GridBagConstraints.<br>
 * Cette classe dfini des styles rutilisables par diffrent composant dans une Grid.
 * 
 * Pour crer un layout fates ce qui suit:<br>
 * - Crer un <code>GridBagLayout</code> et un GridBagHelper</code>.<br>
 * - Prparer la taille des composants (min/prefered/max).<br>
 * - Crer un ou plusieurs style <code>StyleCellule</code>.<br>
 * - Ajouter les composants  la Grid en utilisant la mthode<code>GridBagHelper.ajoute</code>.<br>
 * <br>
 * Exemple:<br>
 * <code>
 *   GridBagLayout layout = new GridBagLayout();<br>
 *   panel.setLayout(layout);<br>
 *   GridBagHelper grid = new GridBagHelper(panel);<br>
 *   <br>
 *   StyleCellule style1 = new StyleCellule(1.0, 0.0,<br>
 *      GridBagConstraints.WEST, GridBagConstraints.VERTICAL, insets, 4, 0);<br>
 *   ...<br>
 *   grid.add(comp1, style1, 0, 0);<br>
 *   grid.add(comp2, style1, 0, 1);<br>
 *   grid.add(comp3, style2, 1, 0);<br>
 *   ..<br>
 * </code>
 */
public class GridBagHelper extends GridBagConstraints {
	
	private static final long serialVersionUID = 8624466142184953714L;
	
	/**
	 * Le container
	 */
    public Container container;

    /**
     * Ajoute une composant au container
     * Le composant occupe seulement une largeur et hauteur de cellule.
     * 
     * @param composant Composant  ajouter
     * @param style Style de la cellule
     * @param ligne Premire cellule en Y
     * @param colonne Premire cellule en X
     */
    public void ajoute(Component composant, StyleCellule style, int ligne, int colonne) {
        ajoute(composant, style, ligne, colonne, 1, 1);
    }

    /**
     * Ajoute une composant au container
     * 
     * @param composant Composant  ajouter
     * @param style Style de la cellule
     * @param ligne Premire cellule en Y
     * @param colonne Premire cellule en X
     * @param hauteurLigne Nombre de cellule dans une colonne (Utiliser GridBagConstraints.REMAINDER pour remplir toute les lignes jusqu' la fin).
     * @param largeurColonne Nombre de cellule dans une ligne (Utiliser GridBagConstraints.REMAINDER pour remplir toute les colonnes jusqu' la fin).
     */
    public void ajoute(Component composant, StyleCellule style, int ligne, int colonne, int hauteurLigne, int largeurColonne) {
        this.gridx = colonne;
        this.gridy = ligne;
        this.gridwidth = largeurColonne;
        this.gridheight = hauteurLigne;
        this.fill = style.fill;
        this.ipadx = style.ipadx;
        this.ipady = style.ipady;
        this.insets = style.insets;
        this.anchor = style.anchor;
        this.weightx = style.weightx;
        this.weighty = style.weighty;
        container.add(composant, this);
    }

    /**
     * Constructeur.
     * @param container Le container
     */
    public GridBagHelper(Container container) {
        super();
        this.container = container;
    }

}
